Include "constants.bb"

AppTitle("You are the darkness")

If Instr(CommandLine(), "-fullscreen")
	Graphics3D(0, 0, 0, 1)
	SCRW = GraphicsWidth()
	
	SCRH = GraphicsHeight()
Else
	Graphics3D(SCRW, SCRH, 0, 2)
	
End If

HidePointer()

Local exitProgram = False
Local timer = CreateTimer(50)


Global Camera = CreateCamera()
CameraClsColor(Camera, LIGHT_EDGE_RED, LIGHT_EDGE_GREEN, LIGHT_EDGE_BLUE)

Global CameraX#, CameraY#, CameraZ# = CAMERA_INIT_Z

Global hudPivot = CreatePivot(Camera)
PositionEntity(hudPivot, 0, 0, 1)


Local lMesh = CreateMesh()
EntityFX(lMesh, 1 + 2 + 32)
Global lSurface = CreateSurface(lMesh)

Local texCircle = LoadTexture("data/circle.png", 1 + 2)
Local overlayTexture = LoadTexture("data/lightoverlay.png", 1)
Local instructionsTex = LoadTexture("data/instructions.png", 1 + 2)
Local diedTex = LoadTexture("data/died.png", 1 + 2)
Local wonTex = LoadTexture("data/won.png", 1 + 2)

Local mouseTex = LoadTexture("data/mouse.png", 1 + 2)

Local oMesh = CreateMesh()
EntityFX(oMesh, 1 + 2 + 32)
EntityTexture(oMesh, texCircle)
Global oSurface = CreateSurface(oMesh)

Local wMesh = CreateMesh()
EntityFX(wMesh, 1 + 2 + 32)
EntityTexture(wMesh, texCircle)
EntityBlend(wMesh, 3)
Global wSurface = CreateSurface(wMesh)

Local pMesh = CreateMesh()
EntityFX(pMesh, 1 + 2 + 32)
EntityTexture(pMesh, texCircle)
Global pSurface = CreateSurface(pMesh)

Local overlayMesh = CreateMesh(hudPivot)
EntityFX(overlayMesh, 1 + 2 + 32)
EntityBlend(overlayMesh, 3)
EntityTexture(overlayMesh, overlayTexture)
Global overlaySurface = CreateSurface(overlayMesh)
EntityOrder(overlayMesh, -5)

Local instructionsMesh = CreateMesh(hudPivot)
EntityFX(instructionsMesh, 1 + 2 + 32)
EntityTexture(instructionsMesh, instructionsTex)
Local instructionsSurface = CreateSurface(instructionsMesh)
EntityOrder(instructionsMesh, -10)

Local diedMesh = CreateMesh(hudPivot)
EntityFX(diedMesh, 1 + 2 + 32)
EntityTexture(diedMesh, diedTex)
Local diedSurface = CreateSurface(diedMesh)
EntityOrder(diedMesh, -10)

Local wonMesh = CreateMesh(hudPivot)
EntityFX(wonMesh, 1 + 2 + 32)
EntityTexture(wonMesh, wonTex)
Local wonSurface = CreateSurface(wonMesh)
EntityOrder(wonMesh, -10)

Local mouseMesh = CreateMesh()
EntityFX(mouseMesh, 1 + 2 + 32)
EntityTexture(mouseMesh, mouseTex)
Local mouseSurface = CreateSurface(mouseMesh)
EntityOrder(mouseMesh, -9)


Global Color_Red = 255
Global Color_Green = 255
Global Color_Blue = 255
Global Color_Alpha# = 1

SetBuffer(BackBuffer())


Global Frame = 0


Global GrandWisp.TGrandWisp

Global Player.TPlayer


Global GameStatus = GAME_STATUS_NOGAME
Global LastGameStatusChange = Frame

Global InstructionsAlpha# = 0
Global InstructionsAlphaGoal# = 1

Global WonAlpha# = 0
Global DiedAlpha# = 0

Global OverlaySize# = 0
Global OverlayAlpha# = 0

Global GrandWispBrightness# = 1


StartNewGame()
ChangeGameStatus(GAME_STATUS_NOGAME)
DeletePlayerParticlesHard()

Repeat
	
	Frame = Frame + 1
	
	
	Select GameStatus
			
		Case GAME_STATUS_NOGAME
			If KeyHit(28) Or KeyHit(57)
				StartNewGame()
			End If
			If KeyHit(1)
				End
			End If
			
		Case GAME_STATUS_INGAME
			If KeyHit(57) Or KeyHit(28) Or KeyHit(25) Or KeyHit(197) Or KeyHit(1)
				ChangeGameStatus(GAME_STATUS_PAUSED)
			End If
			
			
		Case GAME_STATUS_PAUSED
			If KeyHit(57) Or KeyHit(28) Or KeyHit(25) Or KeyHit(197)
				ChangeGameStatus(GAME_STATUS_INGAME)
			End If
			If KeyHit(1)
				End
			End If
			
		Case GAME_STATUS_DIED
			If KeyHit(28) Or KeyHit(1) Or KeyHit(57)
				ChangeGameStatus(GAME_STATUS_NOGAME)
			End If
			
			
		Case GAME_STATUS_WON
			If KeyHit(28) Or KeyHit(1) Or KeyHit(57)
				StartNewGame()
				ChangeGameStatus(GAME_STATUS_NOGAME)
				DeletePlayerParticlesHard()
			End If
			
	End Select
	
	
	Local mx# = ((MouseX() - SCRW / 2) / (SCRW * -0.5)) * CameraZ + CameraX
	Local my# = ((MouseY() - SCRH / 2) / (SCRW * 0.5)) * CameraZ + CameraY
	
	If GameStatus = GAME_STATUS_INGAME
		
		CameraX = CameraX + ((Player\a\x * 0.7 + mx * 0.3) - CameraX) * 0.1
		CameraY = CameraY + ((Player\a\y * 0.7 + my * 0.3) - CameraY) * 0.1
		
	End If
	
	
	PositionEntity(Camera, CameraX, CameraY, CameraZ)
	
	Local gx#, gy#
	
	gx = GrandWisp\a\x + Cos(Frame) * Cos(Frame * 2) * 3
	gy = GrandWisp\a\y + Cos(Frame + 70) * Cos(Frame * 1.5) * 3
	
	DrawLightBackground(gx, gy)
	
	DrawShadows(gx, gy)
	
	CameraClsMode(Camera, True, True)
	RenderWorld()
	
	ClearSurface(lSurface)
	
	
	
	SetSpriteColor(0, 0, 0, 0.5)
	DrawSpriteSquare(mouseSurface, mx, my, 5)
	
	; game logic
	
	If GameStatus = GAME_STATUS_INGAME
		UpdatePlayer()
	End If
	If GameStatus = GAME_STATUS_INGAME Or ((GameStatus = GAME_STATUS_DIED Or GameStatus = GAME_STATUS_NOGAME) And (Frame Mod 2 = 0))
		UpdateGrandWisp()
	
		UpdateWisps()
		UpdateAgents()
	End If
	
	DrawObstacles()
	;DrawWisps()
	
	
	; draw grand
	
	;SetSpriteColor(255, 255, 255, 0.2)
	
	;DrawSpriteSquare(wSurface, GrandWisp\a\x, GrandWisp\a\y, GrandWisp\a\r)
	
	
	
	If GameStatus = GAME_STATUS_INGAME Or GameStatus = GAME_STATUS_PAUSED Or GameStatus = GAME_STATUS_WON
		SetSpriteColor(0, 0, 0, 1)
		;DrawSpriteSquare(pSurface, Player\a\x, Player\a\y, Player\a\r)
	End If
	
	
	
	Local size# 
	
	
	If InstructionsAlphaGoal = 1
		InstructionsAlpha = InstructionsAlpha + 0.01
		If InstructionsAlpha > 1
			InstructionsAlpha = 1
		End If
	Else
		InstructionsAlpha = InstructionsAlpha - 0.03
		If InstructionsAlpha < 0
			InstructionsAlpha = 0
		End If
	End If
	
	If InstructionsAlpha > 0
		size = 1
		SetSpriteColor(255, 255, 255, InstructionsAlpha)
		DrawSpriteRect(instructionsSurface, 0, 0, size,  (size * SCRH) / SCRW)
	End If
	
	
	If GameStatus = GAME_STATUS_DIED
		DiedAlpha = DiedAlpha + 0.01
		If DiedAlpha > 1
			DiedAlpha = 1
		End If
	Else
		DiedAlpha = DiedAlpha - 0.03
		If DiedAlpha < 0
			DiedAlpha = 0
		End If
	End If
	
	
	If DiedAlpha > 0
		size = 0.4
		SetSpriteColor(255, 255, 255, DiedAlpha)
		DrawSpriteRect(diedSurface, 0, 0, 1 * size, size)
	End If
	
	If GameStatus = GAME_STATUS_WON
		WonAlpha = WonAlpha + 0.01
		If WonAlpha > 1
			WonAlpha = 1
		End If
	Else
		WonAlpha = WonAlpha - 0.03
		If WonAlpha < 0
			WonAlpha = 0
		End If
	End If
	
	
	If WonAlpha > 0
		size = 0.4
		SetSpriteColor(200, 200, 200, WonAlpha)
		DrawSpriteRect(wonSurface, 0, 0, 1 * size, size)
	End If
	
	If GameStatus = GAME_STATUS_NOGAME
		OverlayAlpha = OverlayAlpha - 0.02
		If OverlayAlpha < 0
			OverlayAlpha = 0
		End If
	Else
		OverlayAlpha = Player\overlayA + (1 - Player\health)
	End If
	
	If OverlayAlpha > 0
		If OverlayAlpha > 1
			OverlayAlpha = 1
		End If
		
		OverlaySize = 1 + Player\health * 1
		
		size =  OverlaySize
		If size < 1
			size = 1
		End If
		
		SetSpriteColor(LIGHT_CENTER_RED * 1.3, LIGHT_CENTER_GREEN * 1.3, LIGHT_CENTER_BLUE * 1.3, OverlayAlpha)
		
		DrawSpriteRect(overlaySurface, 0, 0, 1 * size,  (size * SCRH) / SCRW)
		
	End If
	
	UpdateParticles()
	
	DrawParticles()
	
	
	
	
	
	CameraClsMode(Camera, False, False)
	RenderWorld()
	
	;Text 0, 0, Player\visible
	
	;If Player\visible > PLAYER_VISIBLE_LIMIT
	;	Text 300, 320, "SEEN"
	;End If
	
	;Rect 0, SCRH - 10, SCRW * Player\health, 10
	Flip(0)
	
	
	ClearSurface(oSurface)
	ClearSurface(wSurface)
	ClearSurface(pSurface)
	ClearSurface(overlaySurface)
	ClearSurface(instructionsSurface)
	ClearSurface(diedSurface)
	ClearSurface(wonSurface)
	ClearSurface(mouseSurface)
	
	Cls()
	
	WaitTimer(timer)
	
	If KeyDown(56) And KeyDown(62)
		exitProgram = True
	End If
	
Until exitProgram

End



Function StartNewGame()
	
	Delete Each TParticle
	Delete Each TAgent
	Delete Each TWisp
	Delete Each TGrandWisp
	Delete Each TPlayer
	Delete Each TObstacle
	Delete Each TShadowLine
	
	GenerateWorld()
	
	MoveMouse(SCRW / 2, SCRH / 2)
	GrandWispBrightness# = 1
	
	ChangeGameStatus(GAME_STATUS_INGAME)
End Function

Function GenerateWorld(obstacleCount = 25, wispCount = 5)
	
	Local o.TObstacle, o2.TObstacle
	Local w.TWisp
	
	Local i, a#, x#, y#, r#
	Local d#, dx#, dy#, dMax#
	
	For i = 1 To obstacleCount
		
		a = Rnd(360)
		r = 50 + Rnd(0, 1) * Rnd(0, 1) * 300
		
		x = Cos(a) * r
		y = Sin(a) * r
		
		CreateObstacle(x, y, 5 + Rnd(0, 1) * Rnd(0, 1) * 10, False)
		
	Next
	
	Local tooClose = True
	
	While tooClose
		tooClose = False
		For o = Each TObstacle
			For o2 = Each TObstacle
				If o <> o2
					
					dx = o\x - o2\x
					dy = o\y - o2\y
					
					d = Sqr(dx * dx + dy * dy)
					
					dMax = o\r + o2\r + GRAND_RADIUS * 3
					
					If d < dMax
						
						
						tooClose = True
						
						dx = dx / d
						dy = dy / d
						
						
						x = (o\x + o2\x) * 0.5
						y = (o\y + o2\y) * 0.5
						
						d = dMax * 0.5 + 0.1
						
						o\x = x + dx * d
						o\y = y + dy * d
						
						o2\x = x - dx * d
						o2\y = y - dy * d
						
					End If
					
				End If
				
				d = Sqr(o\x * o\x + o\y * o\y)
				
				If d < 25
					o\x = o\x / d * 25
					o\y = o\x / d * 25
				End If
				
			Next
		Next
	Wend
	
	
	o2 = Null
	
	
	For o = Each TObstacle
		CreateShadowLinesForObstacle(o)
		
		d = o\x * o\x + o\y * o\y
		If o2 = Null Or d < dMax
			dMax = d
			o2 = o
		End If
		
	Next
	
	For i = 1 To wispCount
		
		a = Rnd(0, 360)
		
		r = Rnd(10, 20)
		
		x = Cos(a) * r
		y = Sin(a) * r
		
		CreateWisp(x, y)
		
	Next
	
	GrandWisp = CreateGrandWisp(0, 0)
	
	dMax = Sqr(dMax)
	dx = o2\x / dMax
	dy = o2\y / dMax
	Player = CreatePlayer(o2\x + dx * (PLAYER_RADIUS + o2\r + 0.5), o2\y + dy * (PLAYER_RADIUS + o2\r + 0.5))
	Player\alive = wispCount
	
	CameraX = Player\a\x
	CameraY = Player\a\y
	
End Function

Function ChangeGameStatus(newStatus)
	
	Select newStatus
			
		Case GAME_STATUS_NOGAME
			InstructionsAlphaGoal# = 1
			
			
		Case GAME_STATUS_INGAME
			InstructionsAlphaGoal# = 0
			
			
		Case GAME_STATUS_PAUSED
			InstructionsAlphaGoal# = 1
			
			
		Case GAME_STATUS_DIED
			
			
		Case GAME_STATUS_WON
			
	End Select
	
	GameStatus = newStatus
	
	FlushMouse()
	FlushKeys()
End Function



Type TParticle
	Field agent.TAgent
	Field x#
	Field y#
	Field vx#
	Field vy#
	Field size#
	Field alpha#
	Field surface
	Field red
	Field green
	Field blue
	Field relative
	Field kind
	Field lifeAlpha#
End Type

Function CreateParticle.TParticle(x#, y#, v#, a#, agent.TAgent, kind)
	Local p.TParticle = New TParticle
	
	p\x = x
	p\y = y
	p\vx = Cos(a) * v
	p\vy = Sin(a) * v
	
	p\agent = agent
	
	Select kind
		Case PARTICLE_KIND_GRAND
			p\red = 255
			p\green = 255
			p\blue = 255
			p\alpha = 0.05
			p\size = Rnd(2, 5)
			p\surface = wSurface
		Case PARTICLE_KIND_PLAYER
			p\red = 0
			p\green = 0
			p\blue = 0
			p\alpha = 0.3
			p\size = Rnd(1, 2)
			p\surface = pSurface
		Case PARTICLE_KIND_WISP
			p\red = 255
			p\green = 255
			p\blue = 255
			p\alpha = 0.05
			p\size = Rnd(0.8, 1.6)
			p\surface = wSurface
	End Select
	
	p\relative = True
	p\kind = kind
	
	Return p
End Function

Function UpdateParticles()
	
	Local p.TParticle
	Local d#, dx#, dy#, f#
	
	For p = Each TParticle
		
		p\lifeAlpha = p\lifeAlpha + (1 - p\lifeAlpha) * 0.01
		If p\lifeAlpha > 1
			p\lifeAlpha = 1
		End If
		
		p\x = p\x + p\vx
		p\y = p\y + p\vy
		
		If Abs(p\vx) > 1 Or Abs(p\vy) > 1
			p\vx = p\vx * 0.95
			p\vy = p\vy * 0.95
		End If
		
		If p\agent <> Null
			
			If p\relative
				If Rnd(0, 1) < 0.01
					p\relative = False
					p\x = p\x + p\agent\x
					p\y = p\y + p\agent\y
				End If
			End If
			
			If p\relative
				dx = - p\x
				dy = - p\y
			Else
				dx = p\agent\x - p\x
				dy = p\agent\y - p\y
			End If
			d = dx * dx + dy * dy
			
			If d < 3
				d = 3
			End If
			
			If d > 60
				d = Sqr(d)
			End If
			
			f = 0.2 / p\agent\r / Sqr(d)
			
			p\vx = p\vx + dx * f
			p\vy = p\vy + dy * f
			
			If p\relative = 0
				p\alpha = p\alpha * 0.95
				If p\alpha < 0.01
					CreateParticlesForAgent(p\agent, p\kind, 1)
					Delete p
				End If
			End If
		Else
			
			p\alpha = p\alpha * 0.9
			If p\alpha < 0.01
				Delete p
			End If
			
		End If
		
	Next
	
End Function

Function DrawParticles()
	
	Local p.TParticle
	
	For p = Each TParticle
		
		SetSpriteColor(p\red, p\green, p\blue, p\alpha * p\lifeAlpha)
		
		If p\agent = Null Or p\relative = 0
			DrawSpriteSquare(p\surface, p\x, p\y, p\size)
		Else
			DrawSpriteSquare(p\surface, p\agent\x + p\x, p\agent\y + p\y, p\size)
		End If
		
	Next
	
End Function

Function CreateParticlesForAgent(agent.TAgent, kind, count = 100)
	
	Local i
	For i = 1 To count
		CreateParticle(Rnd(-1, 1) * Rnd(-1, 1), Rnd(-1, 1) * Rnd(-1, 1), Rnd(0.25, 0.5), Rnd(360), agent, kind)
	Next
	
End Function



Type TObstacle
	Field x#
	Field y#
	Field r#
End Type

Type TShadowLine
	Field x1#
	Field x2#
	Field y1#
	Field y2#
	Field nx#
	Field ny#
End Type

Function DrawLightBackground(x#, y#)
	
	Local centerF# = (1 + Cos(Frame) * 0.05) * GrandWispBrightness
	
	Local centerV = AddVertex(lSurface, x, y, 0)
	VertexColor(lSurface, centerV, LIGHT_EDGE_RED + LIGHT_CENTER_RED * centerF, LIGHT_EDGE_GREEN + LIGHT_CENTER_GREEN * centerF, LIGHT_EDGE_BLUE + LIGHT_CENTER_BLUE * centerF)
	
	Local edgeV[LIGHT_VERTEX_COUNT]
	
	Local i
	
	For i = 0 To LIGHT_VERTEX_COUNT - 1
		Local angle = 360.0 * i / LIGHT_VERTEX_COUNT
		edgeV[i] = AddVertex(lSurface, x + Cos(angle) * LIGHT_RADIUS, y + Sin(angle) * LIGHT_RADIUS, 0)
		VertexColor(lSurface, edgeV[i], LIGHT_EDGE_RED, LIGHT_EDGE_GREEN, LIGHT_EDGE_BLUE, 0)
		;VertexColor(lSurface, edgeV[i], LIGHT_CENTER_RED, LIGHT_CENTER_GREEN, LIGHT_CENTER_BLUE, 0)
	Next
	
	For i = 0 To LIGHT_VERTEX_COUNT - 2
		
		AddTriangle(lSurface, centerV, edgeV[i+1], edgeV[i])
		
	Next
	
	AddTriangle(lSurface, centerV, edgeV[0], edgeV[LIGHT_VERTEX_COUNT - 1])
	
End Function

Function DrawShadows(cx#, cy#)
	
	Local shadowLine.TShadowLine
	
	For shadowLine = Each TShadowLine
		
		Local dx1# = shadowLine\x1 - cx
		Local dy1# = shadowLine\y1 - cy
		
		Local dot = shadowLine\nx * dx1 + shadowLine\ny * dy1
		
		If dot < 0
			
			Local dx2# = shadowLine\x2 - cx
			Local dy2# = shadowLine\y2 - cy
			
			Local x1#, y1#, x2#, y2#
			
			x1 = shadowLine\x1 + dx1 * 10000
			y1 = shadowLine\y1 + dy1 * 10000
			x2 = shadowLine\x2 + dx2 * 10000
			y2 = shadowLine\y2 + dy2 * 10000
			
			Local v0, v1, v2, v3
			
			v0 = AddVertex(lSurface, shadowLine\x1, shadowLine\y1, 0)
			v1 = AddVertex(lSurface, shadowLine\x2, shadowLine\y2, 0)
			
			v2 = AddVertex(lSurface, x1, y1, 0)
			v3 = AddVertex(lSurface, x2, y2, 0)
			
			VertexColor(lSurface, v0, SHADOW_RED, SHADOW_GREEN, SHADOW_BLUE)
			VertexColor(lSurface, v1, SHADOW_RED, SHADOW_GREEN, SHADOW_BLUE)
			VertexColor(lSurface, v2, SHADOW_RED, SHADOW_GREEN, SHADOW_BLUE)
			VertexColor(lSurface, v3, SHADOW_RED, SHADOW_GREEN, SHADOW_BLUE)
			
			AddTriangle(lSurface, v0, v1, v3)
			AddTriangle(lSurface, v0, v3, v2)
			
			; add fuzz
			
			Local v4, v5
			
			Local d#
			
			Local nx1# = dy1
			Local ny1# = - dx1
			
			d = Sqr(nx1 * nx1 + ny1 * ny1)
			
			nx1 = nx1 / d * SHADOW_FUZZ
			ny1 = ny1 / d * SHADOW_FUZZ
			
			Local nx2# = - dy2
			Local ny2# = dx2
			
			
			d = Sqr(nx2 * nx2 + ny2 * ny2)
			
			nx2 = nx2 / d * SHADOW_FUZZ
			ny2 = ny2 / d * SHADOW_FUZZ
			
			
			v4 = AddVertex(lSurface, shadowLine\x2 + nx2, shadowLine\y2 + ny2, 0)
			
			v5 = AddVertex(lSurface, x2 + nx2, y2 + ny2, 0)
			
			VertexColor(lSurface, v4, SHADOW_RED, SHADOW_GREEN, SHADOW_BLUE, 0)
			VertexColor(lSurface, v5, SHADOW_RED, SHADOW_GREEN, SHADOW_BLUE, 0)
			
			AddTriangle(lSurface, v1, v4, v5)
			AddTriangle(lSurface, v1, v5, v3)
			
			
			v4 = AddVertex(lSurface, shadowLine\x1 + nx1, shadowLine\y1 + ny1, 0)
			
			v5 = AddVertex(lSurface, x1 + nx1, y1 + ny1, 0)
			
			VertexColor(lSurface, v4, SHADOW_RED, SHADOW_GREEN, SHADOW_BLUE, 0)
			VertexColor(lSurface, v5, SHADOW_RED, SHADOW_GREEN, SHADOW_BLUE, 0)
			
			AddTriangle(lSurface, v4, v0, v2)
			AddTriangle(lSurface, v4, v2, v5)
			
		End If
		
	Next
	
End Function

Function DrawObstacles()
	Local o.TObstacle
	For o = Each TObstacle
		SetSpriteColor(SHADOW_RED, SHADOW_GREEN, SHADOW_BLUE)
		DrawSpriteSquare(oSurface, o\x, o\y, o\r)
		;SetSpriteColor(OBSTACLE_RED, OBSTACLE_GREEN, OBSTACLE_BLUE)
		;DrawSpriteSquare(oSurface, o\x, o\y, o\r - 0.3, 0)
		;DrawSpriteSquare(oSurface, o\x, o\y, o\r - 0.3, -1.5)
		SetSpriteColor(OBSTACLE_top_RED, OBSTACLE_top_GREEN, OBSTACLE_top_BLUE)
		DrawSpriteSquare(oSurface, o\x, o\y, o\r - 0.3, 0)
	Next
End Function

Function CreateObstacle(x#, y#, r#, createShadowLines = True)
	Local obstacle.TObstacle = New TObstacle
	obstacle\x = x
	obstacle\y = y
	obstacle\r = r
	If createShadowLines
		CreateShadowLinesForObstacle(obstacle)
	End If
End Function

Function CreateShadowLinesForObstacle(obstacle.TObstacle)
	
	Local x#[SHADOWLINES_PER_OBSTACLE]
	Local y#[SHADOWLINES_PER_OBSTACLE]
	
	Local r# = obstacle\r * OBSTACLE_MUL_SHADOW_RADIUS + OBSTACLE_ADD_SHADOW_RADIUS
	
	Local i
	
	For i = 0 To SHADOWLINES_PER_OBSTACLE - 1
		Local angle = 360.0 * i / SHADOWLINES_PER_OBSTACLE
		x[i] = Cos(angle) * r + obstacle\x
		y[i] = Sin(angle) * r + obstacle\y
	Next
	
	For i = 0 To SHADOWLINES_PER_OBSTACLE - 2
		CreateShadowLine(x[i], y[i], x[i+1], y[i+1])
	Next
	CreateShadowLine(x[SHADOWLINES_PER_OBSTACLE - 1], y[SHADOWLINES_PER_OBSTACLE - 1], x[0], y[0])
	
End Function

Function CreateShadowLine(x1#, y1#, x2#, y2#)
	Local l.TShadowLine = New TShadowLine
	l\x1 = x1
	l\y1 = y1
	l\x2 = x2
	l\y2 = y2
	l\nx = y1 - y2
	l\ny = x2 - x1
End Function



Type TAgent
	Field x#
	Field y#
	Field r#
End Type

Function CreateAgent.TAgent(x#, y#, r#)
	Local a.TAgent = New TAgent
	a\x = x
	a\y = y
	a\r = r
	Return a
End Function

Function UpdateAgents()
	Local a.TAgent, o.TObstacle
	For a = Each TAgent
		
		For o = Each TObstacle
			
			Local maxd# = a\r + o\r
			
			Local dx# = a\x - o\x
			
			If Abs(dx) < maxd
				
				Local dy# = a\y - o\y
				
				If Abs(dy) < maxd
					
					Local ds# = dx * dx + dy * dy
					
					If ds < maxd * maxd
						
						Local d# = Sqr(ds)
						
						dx = dx / d
						dy = dy / d
						
						If d < maxd - a\r * 0.45
							maxd = maxd - a\r * 0.45
							a\x = o\x + dx * maxd
							a\y = o\y + dy * maxd
						Else
							a\x = a\x + dx * 0.1
							a\y = a\y + dy * 0.1
						End If
						
					End If
					
					
				End If
				
			End If
			
		Next
		
	Next
End Function


Function DebugCreateAgents()
	Local i
	For i = 0 To 1000
		CreateAgent(Rnd(-200, 200), Rnd(-200, 200), 5)
	Next
End Function

Function DebugUpdateAgents()
	Local a.TAgent
	
	
	For a = Each TAgent
		
		
		a\y= a\y + 0.2
		
	Next
End Function

Function DebugDrawAgents()
	Local a.TAgent
	
	
	For a = Each TAgent
		
		Local f# = GetLightnessAt(a\x, a\y)
		
		SetSpriteColor(255 * f, 255 * f, 255 * f)
		
		DrawSpriteSquare(oSurface, a\x, a\y, a\r)
		
		
	Next
End Function



Type TWisp
	Field a.TAgent
	Field status
	Field nextDecision
	Field goalX#
	Field goalY#
	Field light#
	
	Field vx#
	Field vy#
End Type

Function CreateWisp.TWisp(x#, y#)
	Local w.TWisp = New TWisp
	w\a = CreateAgent(x, y, WISP_RADIUS)
	
	w\nextDecision = Frame + Rand(WISP_LAZY_TIME_MIN, WISP_LAZY_TIME_MAX)
	
	CreateParticlesForAgent(w\a, PARTICLE_KIND_WISP)
	
	Return w
End Function


Function UpdateWisps()
	Local w.TWisp
	Local dx#
	Local dy#
	
	Local d#
	
	For w = Each TWisp
		
		w\light = GetLightnessAt(w\a\x, w\a\y)
		
		If w\nextDecision < Frame
			
			dx# = GrandWisp\a\x - w\a\x
			dy# = GrandWisp\a\y - w\a\y
			
			d# = Sqr(dx * dx + dy * dy)
			
			If d > 30 Or (w\light <> -1 And w\light < WISP_RANDOMWALK_MIN_LIGHT)
				WispFleeLightGoal(w)
				w\status = WISP_STATUS_FLEE
			Else
				Select w\status
					Case WISP_STATUS_LAZY
						w\nextDecision = Frame + 3 ; buffer
						WispRandomGoal(w)
					Case WISP_STATUS_RANDOM
						w\nextDecision = Frame + Rand(WISP_LAZY_TIME_MIN, WISP_LAZY_TIME_MAX)
						w\status = WISP_STATUS_LAZY
					Case WISP_STATUS_FLEE
						w\nextDecision = Frame + Rand(WISP_LAZY_TIME_MIN, WISP_LAZY_TIME_MAX)
						w\status = WISP_STATUS_LAZY
				End Select
			End If
		End If
		
		If w\status <> WISP_STATUS_LAZY
			
			dx# = w\goalX - w\a\x
			dy# = w\goalY - w\a\y
			
			d# = Sqr(dx * dx + dy * dy)
			
			dx = dx / d
			dy = dy / d
			
			Local v# = WISP_RANDOM_ACCELERATION
			
			If w\status = WISP_STATUS_FLEE
				v = v * 2.5
			End If
			
			w\vx = w\vx + dx * v
			w\vy = w\vy + dy * v
			
			If d < w\a\r
				If w\status = WISP_STATUS_FLEE
					w\nextDecision = Frame
				Else
					w\status = WISP_STATUS_LAZY
				End If
			End If
			
		End If
		
		w\vx = w\vx * 0.8
		w\vy = w\vy * 0.8
		
		w\a\x = w\a\x + w\vx
		w\a\y = w\a\y + w\vy
		
	Next
	
End Function

Function WispRandomGoal(w.TWisp)
	Local i, x#, y#, found = False
	For i = 0 To 10
		Local d# = Rnd(WISP_WALK_DISTANCE_MIN, WISP_WALK_DISTANCE_MAX)
		Local angle# = Rnd(0, 360)
		x = w\a\x + Cos(angle) * d
		y = w\a\y + Sin(angle) * d
		If GetObstacleAt(x, y, w\a\r) = Null
			Local l# = GetLightnessAt(x, y)
			If l = -1 Or l > WISP_RANDOMWALK_MIN_LIGHT
				found = True
				Exit
			End If
		End If
	Next
	If found
		
		w\goalX = x
		w\goalY = y
		
		w\status = WISP_STATUS_RANDOM
		w\nextDecision = Frame + Rand(WISP_LAZY_TIME_MIN, WISP_LAZY_TIME_MAX)
	End If
End Function

Function WispFleeLightGoal(w.TWisp)
	Local a# = ATan2(GrandWisp\a\y - w\a\y, GrandWisp\a\x - w\a\x)
	WispFleeAngleGoal(w, a)
End Function

Function WispFleePlayerGoal(w.TWisp)
	Local a# = ATan2(w\a\y - Player\a\y, w\a\x - Player\a\x)
	WispFleeAngleGoal(w, a)
End Function

Function WispFleeAngleGoal(w.TWisp, a#)
	Local i, x#, y#, found = False
	Local bestL# = 1000
	Local bestX#
	Local bestY#
	For i = 0 To 10
		Local d# = Rnd(WISP_WALK_DISTANCE_MIN, WISP_WALK_DISTANCE_MAX)
		Local angle# = a + Rnd(-90, 90)
		
		x = w\a\x + Cos(angle) * d
		y = w\a\y + Sin(angle) * d
		If GetObstacleAt(x, y, w\a\r) = Null
			Local l# = GetLightnessAt(x, y)
			found = True
			
			If l = -1 Or l > WISP_RANDOMWALK_MIN_LIGHT
				bestX = x
				bestY = y
				Exit
			ElseIf bestL > l
				bestL= l
				bestX = x
				bestY = y
			End If
		End If
		
	Next
	If found
		
		w\goalX = bestX
		w\goalY = bestY
		
		w\status = WISP_STATUS_FLEE
		w\nextDecision = Frame + Rand(WISP_LAZY_TIME_MIN, WISP_LAZY_TIME_MAX)
	End If
End Function

Function DrawWisps()
	Local w.TWisp
	SetSpriteColor(255, 255, 255, 0.5)
	For w = Each TWisp
		DrawSpriteSquare(wSurface, w\a\x, w\a\y, w\a\r)
	Next
End Function

Function DeleteWisp(w.TWisp)
	
	Local p.TParticle
	For p = Each TParticle
		
		If p\agent = w\a
			
			If p\relative
				
				p\x = p\x + w\a\x
				p\y = p\y + w\a\y
				
			End If
			
		End If
		
	Next
	
	Delete w\a
	Delete w
	
End Function


Type TGrandWisp
	Field a.TAgent
	Field status
	Field nextDecision
	Field goalX#
	Field goalY#
	Field vx#
	Field vy#
	Field chasePlayerUntil
	Field lastPlayerSeenX#
	Field lastPlayerSeenY#
End Type


Function CreateGrandWisp.TGrandWisp(x#, y#)
	Local w.TGrandWisp = New TGrandWisp
	w\a = CreateAgent(x, y, GRAND_RADIUS)
	
	CreateParticlesForAgent(w\a, PARTICLE_KIND_GRAND)
	
	Return w
End Function

Function UpdateGrandWisp()
	Local w.TGrandWisp = GrandWisp
	
	
	If Player\visible > PLAYER_VISIBLE_LIMIT And Player\isDead = False
		w\chasePlayerUntil = Frame + GRANDWISP_CHASE_TIME
		w\lastPlayerSeenX = Player\a\x
		w\lastPlayerSeenY = Player\a\y
	End If
	
	If w\chasePlayerUntil > Frame
		
		If w\status <> WISP_STATUS_CHASE
			GrandWispFollowGoal(w)
		End If
		
	Else
		
		If w\nextDecision < Frame
			Select w\status
				Case WISP_STATUS_CHASE
					If w\chasePlayerUntil > Frame
						GrandWispFollowGoal(w)
					Else
						w\status = WISP_STATUS_LAZY
					End If
				Case WISP_STATUS_LAZY
					w\nextDecision = Frame + 3 ; buffer
					GrandWispRandomGoal(w)
				Case WISP_STATUS_RANDOM
				;w\nextDecision = Frame + Rand(GRANDWISP_LAZY_TIME_MIN, GRANDWISP_LAZY_TIME_MAX)
				;w\status = WISP_STATUS_LAZY
			End Select
		End If
		
	End If
	
	
	If w\status <> WISP_STATUS_LAZY
		
		Local dx# = w\goalX - w\a\x
		Local dy# = w\goalY - w\a\y
		
		Local d# = Sqr(dx * dx + dy * dy)
		
		dx = dx / d
		dy = dy / d
		
		Local a# = WISP_RANDOM_ACCELERATION
		
		If w\status = WISP_STATUS_CHASE
			a = GRANDWISP_CHASE_SPEED
		End If
		
		w\vx = w\vx + dx * a
		w\vy = w\vy + dy * a
		
		If d < w\a\r
			If w\chasePlayerUntil > Frame
				GrandWispFollowGoal(w)
			Else
				w\status = WISP_STATUS_LAZY
			End If
		End If
		
	End If
	
	w\vx = w\vx * 0.8
	w\vy = w\vy * 0.8
	
	w\a\x = w\a\x + w\vx
	w\a\y = w\a\y + w\vy
	
End Function

Function GrandWispRandomGoal(w.TGrandWisp)
	Local i, x#, y#, found = False
	For i = 0 To 10
		Local d# = Rnd(GRANDWISP_WALK_DISTANCE_MIN, GRANDWISP_WALK_DISTANCE_MAX)
		Local angle# = Rnd(0, 360)
		x = w\a\x + Cos(angle) * d
		y = w\a\y + Sin(angle) * d
		If GetObstacleAt(x, y, w\a\r) = Null
			found = True
			Exit
		End If
	Next
	If found
		
		w\goalX = x
		w\goalY = y
		
		w\status = WISP_STATUS_RANDOM
		w\nextDecision = Frame + Rand(GRANDWISP_LAZY_TIME_MIN, GRANDWISP_LAZY_TIME_MAX)
	End If
End Function

Function GrandWispFollowGoal(w.TGrandWisp)
	Local a# = ATan2(w\lastPlayerSeenY - w\a\y, w\lastPlayerSeenX - w\a\x)
	Local i, x#, y#, found = False
	For i = 0 To 10
		Local d# = Rnd(GRANDWISP_CHASE_DISTANCE_MIN, GRANDWISP_CHASE_DISTANCE_MAX)
		Local angle# = a + (0.5 + i) * (2 * Rand(0, 1) - 1) * 10
		x = w\a\x + Cos(angle) * d
		y = w\a\y + Sin(angle) * d
		If GetObstacleAt(x, y, w\a\r) = Null
			found = True
			Exit
		End If
	Next
	If found
		
		w\goalX = x
		w\goalY = y
		
		w\status = WISP_STATUS_CHASE
		w\nextDecision = Frame + Rand(GRANDWISP_LAZY_TIME_MIN, GRANDWISP_LAZY_TIME_MAX)
	End If
End Function




Type TPlayer
	Field a.TAgent
	Field vx#
	Field vy#
	Field health#
	Field light#
	Field overlayA#
	Field canJumpUntil
	Field canNotJumpUntil
	Field isDead
	Field visible#
	Field winFrame
	Field kills
	Field alive
End Type

Function CreatePlayer.TPlayer(x#, y#)
	Local p.TPlayer = New TPlayer
	p\a = CreateAgent(x, y, PLAYER_RADIUS)
	p\health = 1
	
	CreateParticlesForAgent(p\a, PARTICLE_KIND_PLAYER)
	
	Return p
End Function

Function UpdatePlayer()
	Local p.TPlayer = Player
	
	Local mx# = ((MouseX() - SCRW / 2) / (SCRW * -0.5)) * CameraZ + CameraX
	Local my# = ((MouseY() - SCRH / 2) / (SCRW * 0.5)) * CameraZ + CameraY
	
	Local dx# = mx - p\a\x
	Local dy# = my - p\a\y
	
	Local d# = Sqr(dx * dx + dy * dy)
	
	p\light# = GetLightnessAt(p\a\x, p\a\y)
	
	
	If p\light > SHADOW_LIMIT_LIGHTNESS
		p\overlayA = p\overlayA + (p\light * 2 - p\overlayA) * 0.1
		
		p\visible = p\visible + p\light * 0.05
		
		If p\visible > 1
			p\visible = 1
		End If
		
		p\health = p\health - p\light * PLAYER_DAMAGE_FACTOR
		If p\health < PLAYER_MINHEALTH
			; die!
			p\isDead = True
			p\health = PLAYER_MINHEALTH
			
			ChangeGameStatus(GAME_STATUS_DIED)
			DeletePlayerParticles()
		End If
	Else
		p\visible = p\visible - 0.02
		If p\visible < 0
			p\visible = 0
			
			If p\alive = 0
				If p\health = 1
					
					GrandWispBrightness = GrandWispBrightness - 0.01
					
					If GrandWispBrightness < 0
						GrandWispBrightness = 0
						ChangeGameStatus(GAME_STATUS_WON)
					End If
					
				Else
					
					GrandWispBrightness = GrandWispBrightness + 0.03
					If GrandWispBrightness > 1
						GrandWispBrightness = 1
					End If
				End If
				
			End If
			
		End If
		
		p\overlayA = p\overlayA * 0.8
		p\health = p\health + PLAYER_HP_REGEN
		If p\health > 1
			p\health = 1
		End If
	End If
	
	
	
	If MouseHit(2)
		If False ; MouseDown(1) ; no jumping for now!
			If p\canNotJumpUntil < Frame
				
				p\canNotJumpUntil = Frame + 20
				d = Sqr(dx * dx + dy * dy)
				
				If d > 2
					p\vx = p\vx + dx / d * PLAYER_JUMP_ACCELERATION
					p\vy = p\vy + dy / d * PLAYER_JUMP_ACCELERATION
				End If
				
			End If
		Else
				
			If p\light < SHADOW_LIMIT_LIGHTNESS
				If GetObstacleAt(mx, my, 0) = Null
					If GetLightnessAt(mx, my) < SHADOW_LIMIT_LIGHTNESS
						
						
						DeletePlayerParticles()
						CreateParticlesForAgent(p\a, PARTICLE_KIND_PLAYER)
						
						p\a\x = mx
						p\a\y = my
						
						p\vx = 0
						p\vy = 0
						
						Player\visible = 0
						
						
					End If
				End If
			End If
			
		End If
	End If
	
	
	
	If MouseDown(1)
		If d > 2
			p\vx = p\vx + dx / d * PLAYER_ACCELERATION
			p\vy = p\vy + dy / d * PLAYER_ACCELERATION
		End If
	End If
	
	p\vx = p\vx * PLAYER_INERTIA
	p\vy = p\vy * PLAYER_INERTIA
	
	p\a\x = p\a\x + p\vx
	p\a\y = p\a\y + p\vy
	
	If p\vx * p\vx + p\vy * p\vy < 2
		Local killed = False
		
		Local wisp.TWisp
		For wisp = Each TWisp
			
			dx# = wisp\a\x - p\a\x
			dy# = wisp\a\y - p\a\y
			
			d# = dx * dx + dy * dy
			
			If d < p\a\r * p\a\r
				
				DeleteWisp(wisp)
				p\winFrame = Frame + 100
				
				p\kills = p\kills + 1
				p\alive = p\alive - 1
				
				killed = True
			End If
			
		Next
		
		If killed
			For wisp = Each TWisp
				
				dx# = wisp\a\x - p\a\x
				dy# = wisp\a\y - p\a\y
				
				d# = dx * dx + dy * dy
				
				If d < 25 * 25
					WispFleePlayerGoal(wisp)
				End If
				
			Next
		End If
	End If
	
End Function

Function DeletePlayerParticles()
	Local p.TParticle
	For p = Each TParticle
		If p\kind = PARTICLE_KIND_PLAYER
			If p\relative
				p\x = p\x + Player\a\x
				p\y = p\y + Player\a\y
			End If
			p\relative = False
			p\agent = Null
		End If
	Next
End Function

Function DeletePlayerParticlesHard()
	Local p.TParticle
	For p = Each TParticle
		If p\kind = PARTICLE_KIND_PLAYER
			Delete p
		End If
	Next
End Function





Function GetObstacleAt.TObstacle(x#, y#, r#)
	Local o.TObstacle
	For o = Each TObstacle
		Local maxd# = r + o\r
		
		Local dx# = x - o\x
		
		If Abs(dx) < maxd
			
			Local dy# = y - o\y
			
			If Abs(dy) < maxd
				
				Local ds# = dx * dx + dy * dy
				
				If ds < maxd * maxd
					
					Return o
					
				End If
				
				
			End If
			
		End If
	Next
	Return Null
End Function


Function GetLightnessAt#(x#, y#)
	
	Local px = (x - CameraX) / CameraZ * SCRW * -0.5 + SCRW / 2
	Local py = (y - CameraY) / CameraZ * SCRW * 0.5 + SCRH / 2
	
	If px >= 0 And py >= 0 And px < SCRW And py < SCRH
		
		Local argb = ReadPixel(px, py)
		
		Local l = ((argb Shr 16) And $FF) + ((argb Shr 8) And $FF) + (argb And $FF)
		
		Return l * (1.0 / 255 / 3)
		
	End If
	
	Return -1
End Function



Function SetSpriteColor(r, g, b, a# = 1)
	Color_Red = r
	Color_Green = g
	Color_Blue = b
	Color_Alpha = a
End Function

Function DrawSpriteSquare(surf, x#, y#, r#, z = 0)
	DrawSpriteRect(surf, x, y, r, r, z)
End Function

Function DrawSpriteRect(surf, x#, y#, w#, h#, z# = 0)
	Local v0, v1, v2, v3
	v0 = AddVertex(surf, x - w, y - h, z, 0, 1)
	v1 = AddVertex(surf, x - w, y + h, z, 0, 0)
	v2 = AddVertex(surf, x + w, y - h, z, 1, 1)
	v3 = AddVertex(surf, x + w, y + h, z, 1, 0)
	VertexColor(surf, v0, Color_Red, Color_Green, Color_Blue, Color_Alpha)
	VertexColor(surf, v1, Color_Red, Color_Green, Color_Blue, Color_Alpha)
	VertexColor(surf, v2, Color_Red, Color_Green, Color_Blue, Color_Alpha)
	VertexColor(surf, v3, Color_Red, Color_Green, Color_Blue, Color_Alpha)
	AddTriangle(surf, v0, v1, v2)
	AddTriangle(surf, v1, v3, v2)
End Function



